<?php
class MISPaySDKUtil
{
    public static function encrypt(string $plaintext, string $passphrase)
    {
        $salt = openssl_random_pseudo_bytes(16);
        $nonce = openssl_random_pseudo_bytes(12);
        $key = hash_pbkdf2("sha256", $passphrase, $salt, 40000, 32, true);
        $ciphertext = openssl_encrypt($plaintext, 'aes-256-gcm', $key, 1, $nonce, $tag);

        return base64_encode($salt . $nonce . $ciphertext . $tag);
    }

    public static function decrypt(string $ciphertext, string $passphrase)
    {
        $input = base64_decode($ciphertext);
        $salt = substr($input, 0, 16);
        $nonce = substr($input, 16, 12);
        $ciphertext = substr($input, 28, -16);
        $tag = substr($input, -16);
        $key = hash_pbkdf2("sha256", $passphrase, $salt, 40000, 32, true);

        return openssl_decrypt($ciphertext, 'aes-256-gcm', $key, 1, $nonce, $tag);
    }
}


define('MISPAY', [
    'BASE_URL' => $_ENV['MISPAY_BASE_URL'],
    'APP_ID' => $_ENV['MISPAY_APP_ID'],
    'APP_SECRET' => $_ENV['MISPAY_APP_SECRET'],
]);
class MISPaySDKConstants
{

    private const BASE_URL = MISPAY['BASE_URL'];
    private const APP_ID = MISPAY['APP_ID'];
    private const APP_SECRET = MISPAY['APP_SECRET'];
    private const ENDPOINTS = [
        'token' => '/token',
        'startCheckoutSession' => '/start-checkout',
        'getCheckoutDetail' => '/checkout/:id',
        "trackCheckout" => "/track-checkout/:id",
        'endCheckoutSession' => '/checkout/:id/end',

    ];

    public static function getBaseUrl()
    {
        return rtrim(self::BASE_URL, '/');
    }

    public static function getCredentials()
    {
        $credentials = new stdClass();

        $credentials->appId = self::APP_ID;
        $credentials->appSecret = self::APP_SECRET;

        return $credentials;
    }

    public static function getEndpoints()
    {
        return self::ENDPOINTS;
    }
}

class MISPaySDK
{

    private static $instance = null;
    private static $accessToken = null;

    private function __construct()
    {
    }

    private function setAccessToken($token)
    {
        self::$accessToken = $token;
    }

    private function getAccessToken()
    {
        return self::$accessToken;
    }

    public static function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new MISPaySDK();
        }

        return self::$instance;
    }

    private function getToken()
    {

        $curl = curl_init();
        $url = MISPaySDKConstants::getBaseUrl() . MISPaySDKConstants::getEndpoints()['token'];
        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => array(
                'x-app-secret: ' . MISPaySDKConstants::getCredentials()->appSecret,
                "x-app-id: " . MISPaySDKConstants::getCredentials()->appId
            ),
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        );
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $responseBody = json_decode($response);

        print_r($responseBody);

        $dec =  MISPaySDKUtil::decrypt($responseBody->result->token, MISPaySDKConstants::getCredentials()->appSecret);
        $payload = json_decode(($dec));
        $this->setAccessToken($payload->token);
    }

    public function trackCheckout($checkoutId)
    {
        if ($this->getAccessToken() === null) {
            $this->getToken();
        }
        $accessToken = $this->getAccessToken();
        $url = MISPaySDKConstants::getBaseUrl() . MISPaySDKConstants::getEndpoints()['trackCheckout'];
        $url = str_replace(':id', $checkoutId, $url);
        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => array(
                'x-app-secret: ' . MISPaySDKConstants::getCredentials()->appSecret,
                "x-app-id: " . MISPaySDKConstants::getCredentials()->appId,
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json'
            ),
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        );

        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $responseBody = json_decode($response);
        return $responseBody;
    }


    public function startCheckoutSession($orderId, $price)
    {
        if ($this->getAccessToken() === null) {
            $this->getToken();
        }
        $accessToken = $this->getAccessToken();
        $url = MISPaySDKConstants::getBaseUrl() . MISPaySDKConstants::getEndpoints()['startCheckoutSession'];

        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => array(
                'x-app-secret: ' . MISPaySDKConstants::getCredentials()->appSecret,
                "x-app-id: " . MISPaySDKConstants::getCredentials()->appId,
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS => '{
                "orderId": "' . $orderId . '",
                "purchaseAmount": ' . $price . ',
                "purchaseCurrency": "SAR"
            }',

            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        );
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $responseBody = json_decode($response);
        return $responseBody->result;
    }

    public function decyrptResult($encyrptedValue)
    {
        return MISPaySDKUtil::decrypt(base64_decode($encyrptedValue), MISPaySDKConstants::getCredentials()->appSecret);
    }

    public function getCheckoutDetail($checkoutId)
    {
        if ($this->getAccessToken() === null) {
            $this->getToken();
        }
        $accessToken = $this->getAccessToken();
        $url = MISPaySDKConstants::getBaseUrl() . MISPaySDKConstants::getEndpoints()['getCheckoutDetail'];
        $url = str_replace(':id', $checkoutId, $url);

        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => array(
                'x-app-secret: ' . MISPaySDKConstants::getCredentials()->appSecret,
                "x-app-id: " . MISPaySDKConstants::getCredentials()->appId,
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json'
            ),
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        );

        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $responseBody = json_decode($response);
        if (isset($responseBody->status) && $responseBody->status === 'success') {
            return $responseBody->result;
        }


        if (isset($responseBody->status) && $responseBody->status === 'error') {
            print_r($responseBody->result);
        }
    }

    public function endCheckoutSession($checkoutId)
    {
        if ($this->getAccessToken() === null) {
            $this->getToken();
        }
        $accessToken = $this->getAccessToken();
        $url = MISPaySDKConstants::getBaseUrl() . MISPaySDKConstants::getEndpoints()['endCheckoutSession'];
        $url = str_replace(':id', $checkoutId, $url);
        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => array(
                'x-app-secret: ' . MISPaySDKConstants::getCredentials()->appSecret,
                "x-app-id: " . MISPaySDKConstants::getCredentials()->appId,
                'Authorization: Bearer ' . $accessToken,
                'Content-Type: application/json'
            ),
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        );

        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $responseBody = json_decode($response);
        return $responseBody;
    }
}
